unit MyScrollBar;

interface

uses
  SysUtils, Classes, Controls, Graphics, Forms, Messages, Types, ExtCtrls;

type
  TPosition=(spLeftUp,spCenter,spRightDown,spNone);
  TMyScrollBar = class(TCustomControl)
  private
    { Private declarations }
  protected
    { Protected declarations }
    FPosition:word;
    FScrollBarKind:TSCrollBarKind;
    FCurrentPosition:TPosition;
    FBackGroundColor:TColor;
    FArrowColor: TColor;
    FArrowBackGroundColor:TColor;
    FClickedColor:TColor;
    FClicked:boolean;
    FScrollButtonSize:word;
    FSize:word;
    FScrollButtoncolor:TColor;
    FTimer:TTimer;
    procedure SetScrollBarKind(Value:TScrollBarKind);
    procedure MySetCurrentPosition(Value:TPosition);
    procedure SetBackGroundColor(Value:TColor);
    procedure SetArrowColor(Value:TColor);
    procedure SetArrowBackGroundColor(Value:TColor);
    procedure SetClickedColor(Value:TColor);
    procedure SetClicked(Value:boolean);
    function GetScrollButtonSize:word;
    procedure SetSize(Value:word);
    procedure SetScrollButtonColor(Value:TColor);
    procedure SetMyPosition(Value:word);
    procedure OnTimer(Sender:TObject);
    procedure SetInterval(Value:Cardinal);
    function GetInterval:cardinal;
    procedure WMNCHitTest(var Message:TWMNCHitTest);message WM_NCHitTest;
    procedure CMMouseLeave(var Message:TMessage);message CM_MOUSELEAVE;
    procedure WMLButtonDown(var Message:TWMLButtonDown);message WM_LBUTTONDOWN;
    procedure WMLButtonUp(var Message:TWMLButtonUp);message WM_LBUTTONUP;
    property CurrentPosition:TPosition read FCurrentPosition write MySetCurrentPosition;
    property MyClicked:boolean read FClicked write SetClicked;
    property ScrollButtonSize:word read GetScrollButtonSize;
    property MyPosition:word read FPosition write SetMyPosition;
  public
    { Public declarations }
    procedure Paint;override;
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
  published
    { Published declarations }
    property Position:word read FPosition write SetMyPosition;
    property Kind:TScrollBarKind read FScrollBarKind write SetScrollBarKind;
    property BackGroundColor:TColor read FBackGroundColor write SetBackGroundColor;
    property ArrowColor:TColor read FArrowColor write SetArrowColor;
    property ArrowBackGroundColor:TColor read FArrowBackGroundColor write SetArrowBackGroundColor;
    property ClickedColor:TColor read FClickedColor write SetClickedColor;
    property Clicked:boolean read FClicked;
    property Size:word read FSize write SetSize;
    property ScrollButtonColor:TColor read FScrollButtonColor write SetScrollButtonColor;
    property Delay:Cardinal read GetInterval write SetInterval;
    property Align;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TMyScrollBar]);
end;

{ TMyScrollBar }

procedure TMyScrollBar.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  CurrentPosition:=spNone;
end;

constructor TMyScrollBar.Create(AOwner: TComponent);
begin
  inherited;
  Kind:=sbVertical;
  FCurrentPosition:=spNone;
  FBackGroundColor:=clBtnFace;
  FArrowBackGroundColor:=clBtnFace;
  FArrowColor:=clBtnFace;
  FSize:=100;
  FPosition:=1;
  FTimer:=TTimer.Create(nil);
  FTimer.Enabled:=false;
  FTimer.OnTimer:=OnTimer;
  FTimer.Interval:=100;
end;

destructor TMyScrollBar.Destroy;
begin
  FTimer.Free;
  inherited;
end;

function TMyScrollBar.GetInterval: cardinal;
begin
  Result:=FTimer.Interval;
end;

function TMyScrollBar.GetScrollButtonSize: word;
var V:word;
begin
  Result:=3;
  case FScrollBarKind of
    sbHorizontal:
      begin
        V:=Height;
        if Height>=Width div 5 then
          begin
            V:=Width div 7;
            if V<=10 then V:=10;
          end;
        Result:=(Width-2*V-6) div FSize;
      end;
    sbVertical:
      begin
        V:=Width;
        if Width>=Height div 5 then
          begin
            V:=Height div 7;
            if V<=10 then V:=10;
          end;
        Result:=(Height-2*V-6) div FSize;
      end;
  end;//case
  if Result<3 then Result:=3;
end;

procedure TMyScrollBar.MySetCurrentPosition(Value: TPosition);
var V:word;
begin
  if Value=FCurrentPosition then exit;
  //
    case FScrollBarKind of
      sbHorizontal:
        begin
          V:=Height;
          if Height>=Width div 5 then
            begin
              V:=Width div 7;
              if V<=10 then V:=10;
            end;
          case FCurrentPosition of
            spLeftUp:
              begin
                Canvas.Brush.Color:=FArrowBackGroundColor;
                Canvas.Brush.Style:=bsSolid;
                Canvas.Pen.Style:=psClear;
                Canvas.Rectangle(1,1,V+1,Height);
              end;//spLeftUp
            spRightDown:
              begin
                Canvas.Brush.Color:=FArrowBackGroundColor;
                Canvas.Brush.Style:=bsSolid;
                Canvas.Pen.Style:=psClear;
                Canvas.Rectangle(Width-V+1,1,Width,Height);
              end;
            spCenter:;
          end;//case
        end;//sbHorizontal
        sbVertical:
          begin
            V:=Width;
            if Width>=Height div 5 then
              begin
                V:=Height div 7;
                if V<=10 then V:=10;
            end;
            case FCurrentPosition of
              spLeftUp:
                begin
                  Canvas.Brush.Color:=FArrowBackGroundColor;
                  Canvas.Pen.Style:=psClear;
                  Canvas.Brush.Style:=bsSolid;
                  Canvas.Rectangle(1,1,Width,V+1);
                end;
              spRightDown:
                begin
                  Canvas.Brush.Color:=FArrowBackGroundColor;
                  Canvas.Pen.Style:=psClear;
                  Canvas.Brush.Style:=bsSolid;
                  Canvas.Rectangle(1,Height-V+1,Width,Height);
                end;
            end;//case
          end;//sbVertical
    end;
  //
  case FScrollBarKind of
    sbHorizontal:
      begin
        //------------------------------ 
        V:=Height;
        if Height>=Width div 5 then
          begin
            V:=Width div 7;
            if V<=10 then V:=10;
          end;
        //------------------------------
        case Value of
          spRightDown:
            begin
              case FClicked of
                true:Canvas.Brush.Color:=FClickedColor;
                false:Canvas.Brush.Color:=FArrowColor;
              end;
              Canvas.Brush.Style:=bsSolid;
              Canvas.Pen.Style:=psClear;
              Canvas.Rectangle(Width-V+1,1,Width,Height);
            end;
          spLeftUp:
            begin
              case FClicked of
                true:Canvas.Brush.Color:=FClickedColor;
                false:Canvas.Brush.Color:=FArrowColor;
              end;
              Canvas.Brush.Style:=bsSolid;
              Canvas.Pen.Style:=psClear;
              Canvas.Rectangle(1,1,V+1,Height);
            end;
          end;//case
        end;//sbHorizontal
      sbVertical:
        begin
          V:=Width;
            if Width>=Height div 5 then
              begin
                V:=Height div 7;
                if V<=10 then V:=10;
            end;
          case Value of
            spLeftUp:
              begin
                case FClicked of
                  true:Canvas.Brush.Color:=FClickedColor;
                  false:Canvas.Brush.Color:=FArrowColor;
                end;
                Canvas.Pen.Style:=psClear;
                Canvas.Brush.Style:=bsSolid;
                Canvas.Rectangle(1,1,Width,V+1);
              end;
              spRightDown:
                begin
                  case FClicked of
                    true:Canvas.Brush.Color:=FClickedColor;
                    false:Canvas.Brush.Color:=FArrowColor;
                  end;
                  Canvas.Pen.Style:=psClear;
                  Canvas.Brush.Style:=bsSolid;
                  Canvas.Rectangle(1,Height-V+1,Width,Height);
                end;
          end;
        end;//sbVertical
  end;//case
  FCurrentPosition := Value;
  //Invalidate;
end;

procedure TMyScrollBar.OnTimer(Sender: TObject);
begin
  case FCurrentPosition of
    spLeftUp:if MyPosition-1>=0 then MyPosition:=MyPosition-1;
    spCenter:;
    spRightDown:if MyPosition+1<=FSize then MyPosition:=MyPosition+1;
  end;  
end;

procedure TMyScrollBar.Paint;
var V:word;
    SB:TRect;
begin
  inherited;
  Canvas.Brush.Color:=FBackGroundColor;
  Canvas.Pen.Style:=psSolid;
  Canvas.Rectangle(0,0,Width,Height);
  case FScrollBarKind of
    sbHorizontal:
      begin
        V:=Height;
        if Height>=Width div 5 then
          begin
            V:=Width div 7;
            if V<=10 then V:=10;
          end;
        // 
        Canvas.Brush.Color:=FArrowBackGroundColor;
        if CurrentPosition=spLeftUp then Canvas.Brush.Color:=FArrowColor;
        if (CurrentPosition=spLeftUp)and(FClicked) then Canvas.Brush.Color:=FClickedColor;
        Canvas.MoveTo(V,0);
        Canvas.LineTo(V,Height);
        Canvas.Pen.Style:=psClear;
        Canvas.Rectangle(1,1,V+1,Height);
        Canvas.Pen.Style:=psSolid;
        // 
        Canvas.Brush.Color:=FArrowBackGroundColor;
        if CurrentPosition=spRightDown then Canvas.Brush.Color:=FArrowColor;
        if (CurrentPosition=spRightDown)and(FClicked) then Canvas.Brush.Color:=FClickedColor;
        Canvas.MoveTo(Width-V,0);
        Canvas.LineTo(Width-V,Height);
        Canvas.Pen.Style:=psClear;
        Canvas.Rectangle(Width-V+1,1,Width,Height);
        Canvas.Pen.Style:=psSolid;
        // 
        Canvas.Brush.Color:=FScrollButtonColor;
        Canvas.Brush.Style:=bsSolid;
        if FPosition<FSize then
          begin
            SB.Left:=(V+3)+((Width-2*V)div FSize)*(FPosition-1);
            SB.Top:=2;
            SB.Bottom:=Height-2;
            SB.Right:=SB.Left+ScrollButtonSize;
            Canvas.Rectangle(SB)
          end
            else Canvas.Rectangle(Width-V-ScrollButtonSize-3,2,Width-V-3,Height-2);

      end;//scHorizontal
    sbVertical:
      begin
        V:=Width;
        if Width>=Height div 5 then
          begin
            V:=Height div 7;
            if V<=10 then V:=10;
          end;
        // 
        Canvas.Brush.Color:=FArrowBackGroundColor;
        if CurrentPosition=spLeftUp then Canvas.Brush.Color:=FArrowColor;
        if (CurrentPosition=spLeftUp)and(FClicked) then Canvas.Brush.Color:=FClickedColor;
        Canvas.MoveTo(0,V);
        Canvas.LineTo(Width,V);
        Canvas.Pen.Style:=psClear;
        Canvas.Rectangle(1,1,Width,V+1);
        Canvas.Pen.Style:=psSolid;
        // 
        Canvas.Brush.Color:=FArrowBackGroundColor;
        if CurrentPosition=spRightDown then Canvas.Brush.Color:=FArrowColor;
        if (CurrentPosition=spRightDown)and(FClicked) then Canvas.Brush.Color:=FClickedColor;
        Canvas.MoveTo(0,Height-V);
        Canvas.LineTo(Width,Height-V);
        Canvas.Pen.Style:=psClear;
        Canvas.Rectangle(1,Height-V+1,Width,Height);
        Canvas.Pen.Style:=psSolid;
        // 
        Canvas.Brush.Color:=FScrollButtonColor;
        Canvas.Brush.Style:=bsSolid;
        if FPosition<FSize then
          begin
            SB.Top:=(V+3)+((Height-2*V)div FSize)*(FPosition-1);
            SB.Left:=2;
            SB.Right:=Width-2;
            SB.Bottom:=SB.Top+ScrollButtonSize;
            Canvas.Rectangle(SB)
          end
            else Canvas.Rectangle(2,Height-V-ScrollButtonSize-3,Width-2,Height-V-3);
      end;
  end;
end;

procedure TMyScrollBar.SetArrowBackGroundColor(Value: TColor);
begin
  if FArrowBackGroundColor=Value then exit;
  FArrowBackGroundColor:=Value;
  Invalidate;
end;

procedure TMyScrollBar.SetArrowColor(Value: TColor);
begin
  if Value=FArrowColor then exit;
  FArrowColor:=Value;
  Invalidate;
end;

procedure TMyScrollBar.SetBackGroundColor(Value: TColor);
begin
  if FBackGroundColor=Value then exit;
  FBackGroundColor:=Value;
  Invalidate;
end;

procedure TMyScrollBar.SetClicked(Value: boolean);
var temp:TPosition;
begin
  if FClicked=Value then exit;
  FClicked:=Value;
  temp:=CurrentPosition;
  CurrentPosition:=spNone;
  CurrentPosition:=temp;
end;

procedure TMyScrollBar.SetClickedColor(Value: TColor);
begin
  if FClickedColor=Value then exit;
  FClickedColor:=Value;
  Invalidate;
end;

procedure TMyScrollBar.SetInterval(Value: Cardinal);
begin
  if Value=0 then Value:=75;
  FTimer.Interval:=Value;
end;

procedure TMyScrollBar.SetMyPosition(Value: word);
begin
  if FPosition=Value then exit;
  if Value=0 then Value:=1;
  if Value>FSize then Value:=FSize;
  FPosition:=Value;
  Invalidate;
end;

procedure TMyScrollBar.SetScrollBarKind(Value:TScrollBarKind);
begin
  if FScrollBarKind=Value then exit;
  FScrollBarKind:=Value;
  CurrentPosition:=CurrentPosition;
end;

procedure TMyScrollBar.SetScrollButtonColor(Value: TColor);
begin
  if FScrollButtonColor=Value then exit;
  FScrollButtonColor:=Value;
  Invalidate;
end;

procedure TMyScrollBar.SetSize(Value: word);
begin
  if Value=FSize then exit;
  if Value=0 then Value:=1;
  FSize:=Value;
  Invalidate;
end;

procedure TMyScrollBar.WMLButtonDown(var Message: TWMLButtonDown);
begin
  inherited;
  MyClicked:=true;//  
  case FCurrentPosition of
    spLeftUp:if FPosition<>1 then FTimer.Enabled:=true;
    spRightDown:if FPosition<>FSize then FTimer.Enabled:=true;
  end;
end;

procedure TMyScrollBar.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  MyClicked:=false;
  FTimer.Enabled:=false;
end;

procedure TMyScrollBar.WMNCHitTest(var Message: TWMNCHitTest);
var pos:TPoint;
    V:word;
begin
  inherited;
  pos:=ScreenToClient(Point(Message.XPos,Message.YPos));
  case FScrollBarKind of
    sbHorizontal:
      begin
        V:=Height;
        if Height>=Width div 5 then
          begin
            V:=Width div 7;
            if V<=10 then V:=10;
          end;
        if(pos.X>0)and(pos.X<V) then//spLeftUp
            CurrentPosition:=spLeftUp;
        if (pos.X>Width-V)and(pos.X<Width) then//spRightDown
            CurrentPosition:=spRightDown;
        if (Pos.X>V)and(pos.X<Width-V) then//spCenter
          CurrentPosition:=spCenter;
      end;
    sbVertical:
      begin
        V:=Width;
        if Width>=Height div 5 then
          begin
            V:=Height div 7;
            if V<=10 then V:=10;
          end;
        if(pos.Y>0)and(pos.Y<V) then//spLeftUp
          CurrentPosition:=spLeftUp;
        if(pos.Y>V)and(pos.Y<Height-V) then//spCenter
          CurrentPosition:=spCenter;
        if(pos.Y>Height-V+1)and(pos.Y<Height) then//spRightDown
          CurrentPosition:=spRightDown;
      end;
  end;//case
end;

end.


